/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Values for an attribute with a `value_type` of REPEATED_ENUM. This consists of two lists of value
 * IDs: those that are set (true) and those that are unset (false). Values absent are considered
 * unknown. At least one value must be specified.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RepeatedEnumAttributeValue extends com.google.api.client.json.GenericJson {

  /**
   * Enum values that are set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> setValues;

  /**
   * Enum values that are unset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> unsetValues;

  /**
   * Enum values that are set.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSetValues() {
    return setValues;
  }

  /**
   * Enum values that are set.
   * @param setValues setValues or {@code null} for none
   */
  public RepeatedEnumAttributeValue setSetValues(java.util.List<java.lang.String> setValues) {
    this.setValues = setValues;
    return this;
  }

  /**
   * Enum values that are unset.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getUnsetValues() {
    return unsetValues;
  }

  /**
   * Enum values that are unset.
   * @param unsetValues unsetValues or {@code null} for none
   */
  public RepeatedEnumAttributeValue setUnsetValues(java.util.List<java.lang.String> unsetValues) {
    this.unsetValues = unsetValues;
    return this;
  }

  @Override
  public RepeatedEnumAttributeValue set(String fieldName, Object value) {
    return (RepeatedEnumAttributeValue) super.set(fieldName, value);
  }

  @Override
  public RepeatedEnumAttributeValue clone() {
    return (RepeatedEnumAttributeValue) super.clone();
  }

}
