/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A single insurance network. Next id: 5
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InsuranceNetwork extends com.google.api.client.json.GenericJson {

  /**
   * Required. The id of this insurance network generated by Google.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String networkId;

  /**
   * Output only. A map of network display names in requested languages where the language is the
   * key and localized display name is the value. The display name in English is set by default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> networkNames;

  /**
   * Output only. A map of payer display names in requested languages where the language is the key
   * and localized display name is the value. The display name in English is set by default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> payerNames;

  /**
   * Output only. The state of this insurance network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Required. The id of this insurance network generated by Google.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetworkId() {
    return networkId;
  }

  /**
   * Required. The id of this insurance network generated by Google.
   * @param networkId networkId or {@code null} for none
   */
  public InsuranceNetwork setNetworkId(java.lang.String networkId) {
    this.networkId = networkId;
    return this;
  }

  /**
   * Output only. A map of network display names in requested languages where the language is the
   * key and localized display name is the value. The display name in English is set by default.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getNetworkNames() {
    return networkNames;
  }

  /**
   * Output only. A map of network display names in requested languages where the language is the
   * key and localized display name is the value. The display name in English is set by default.
   * @param networkNames networkNames or {@code null} for none
   */
  public InsuranceNetwork setNetworkNames(java.util.Map<String, java.lang.String> networkNames) {
    this.networkNames = networkNames;
    return this;
  }

  /**
   * Output only. A map of payer display names in requested languages where the language is the key
   * and localized display name is the value. The display name in English is set by default.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getPayerNames() {
    return payerNames;
  }

  /**
   * Output only. A map of payer display names in requested languages where the language is the key
   * and localized display name is the value. The display name in English is set by default.
   * @param payerNames payerNames or {@code null} for none
   */
  public InsuranceNetwork setPayerNames(java.util.Map<String, java.lang.String> payerNames) {
    this.payerNames = payerNames;
    return this;
  }

  /**
   * Output only. The state of this insurance network.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The state of this insurance network.
   * @param state state or {@code null} for none
   */
  public InsuranceNetwork setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public InsuranceNetwork set(String fieldName, Object value) {
    return (InsuranceNetwork) super.set(fieldName, value);
  }

  @Override
  public InsuranceNetwork clone() {
    return (InsuranceNetwork) super.clone();
  }

}
