/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.android.json;

import android.annotation.TargetApi;
import android.util.JsonReader;
import android.util.JsonToken;
import com.google.api.client.extensions.android.json.AndroidJsonFactory;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
@Beta
class AndroidJsonParser
extends JsonParser {
    private final JsonReader reader;
    private final AndroidJsonFactory factory;
    private List<String> currentNameStack = new ArrayList<String>();
    private com.google.api.client.json.JsonToken currentToken;
    private String currentText;

    AndroidJsonParser(AndroidJsonFactory factory, JsonReader reader) {
        this.factory = factory;
        this.reader = reader;
        reader.setLenient(true);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public String getCurrentName() {
        return this.currentNameStack.isEmpty() ? null : this.currentNameStack.get(this.currentNameStack.size() - 1);
    }

    public com.google.api.client.json.JsonToken getCurrentToken() {
        return this.currentToken;
    }

    public JsonFactory getFactory() {
        return this.factory;
    }

    public byte getByteValue() {
        this.checkNumber();
        return Byte.parseByte(this.currentText);
    }

    public short getShortValue() {
        this.checkNumber();
        return Short.parseShort(this.currentText);
    }

    public int getIntValue() {
        this.checkNumber();
        return Integer.parseInt(this.currentText);
    }

    public float getFloatValue() {
        this.checkNumber();
        return Float.parseFloat(this.currentText);
    }

    public BigInteger getBigIntegerValue() {
        this.checkNumber();
        return new BigInteger(this.currentText);
    }

    public BigDecimal getDecimalValue() {
        this.checkNumber();
        return new BigDecimal(this.currentText);
    }

    public double getDoubleValue() {
        this.checkNumber();
        return Double.parseDouble(this.currentText);
    }

    public long getLongValue() {
        this.checkNumber();
        return Long.parseLong(this.currentText);
    }

    private void checkNumber() {
        Preconditions.checkArgument((this.currentToken == com.google.api.client.json.JsonToken.VALUE_NUMBER_INT || this.currentToken == com.google.api.client.json.JsonToken.VALUE_NUMBER_FLOAT ? 1 : 0) != 0);
    }

    public String getText() {
        return this.currentText;
    }

    public com.google.api.client.json.JsonToken nextToken() throws IOException {
        JsonToken peek;
        if (this.currentToken != null) {
            switch (this.currentToken) {
                case START_ARRAY: {
                    this.reader.beginArray();
                    this.currentNameStack.add(null);
                    break;
                }
                case START_OBJECT: {
                    this.reader.beginObject();
                    this.currentNameStack.add(null);
                    break;
                }
            }
        }
        try {
            peek = this.reader.peek();
        }
        catch (EOFException e) {
            peek = JsonToken.END_DOCUMENT;
        }
        switch (peek) {
            case BEGIN_ARRAY: {
                this.currentText = "[";
                this.currentToken = com.google.api.client.json.JsonToken.START_ARRAY;
                break;
            }
            case END_ARRAY: {
                this.currentText = "]";
                this.currentToken = com.google.api.client.json.JsonToken.END_ARRAY;
                this.currentNameStack.remove(this.currentNameStack.size() - 1);
                this.reader.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                this.currentText = "{";
                this.currentToken = com.google.api.client.json.JsonToken.START_OBJECT;
                break;
            }
            case END_OBJECT: {
                this.currentText = "}";
                this.currentToken = com.google.api.client.json.JsonToken.END_OBJECT;
                this.currentNameStack.remove(this.currentNameStack.size() - 1);
                this.reader.endObject();
                break;
            }
            case BOOLEAN: {
                if (this.reader.nextBoolean()) {
                    this.currentText = "true";
                    this.currentToken = com.google.api.client.json.JsonToken.VALUE_TRUE;
                    break;
                }
                this.currentText = "false";
                this.currentToken = com.google.api.client.json.JsonToken.VALUE_FALSE;
                break;
            }
            case NULL: {
                this.currentText = "null";
                this.currentToken = com.google.api.client.json.JsonToken.VALUE_NULL;
                this.reader.nextNull();
                break;
            }
            case STRING: {
                this.currentText = this.reader.nextString();
                this.currentToken = com.google.api.client.json.JsonToken.VALUE_STRING;
                break;
            }
            case NUMBER: {
                this.currentText = this.reader.nextString();
                this.currentToken = this.currentText.indexOf(46) == -1 ? com.google.api.client.json.JsonToken.VALUE_NUMBER_INT : com.google.api.client.json.JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case NAME: {
                this.currentText = this.reader.nextName();
                this.currentToken = com.google.api.client.json.JsonToken.FIELD_NAME;
                this.currentNameStack.set(this.currentNameStack.size() - 1, this.currentText);
                break;
            }
            default: {
                this.currentText = null;
                this.currentToken = null;
            }
        }
        return this.currentToken;
    }

    public JsonParser skipChildren() throws IOException {
        if (this.currentToken != null) {
            switch (this.currentToken) {
                case START_ARRAY: {
                    this.reader.skipValue();
                    this.currentText = "]";
                    this.currentToken = com.google.api.client.json.JsonToken.END_ARRAY;
                    break;
                }
                case START_OBJECT: {
                    this.reader.skipValue();
                    this.currentText = "}";
                    this.currentToken = com.google.api.client.json.JsonToken.END_OBJECT;
                    break;
                }
            }
        }
        return this;
    }
}

