/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Conveniences provided in guest units to facilitate an easier, more comfortable stay.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Housekeeping extends com.google.api.client.json.GenericJson {

  /**
   * Daily housekeeping. Guest units are cleaned by hotel staff daily during guest's stay.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean dailyHousekeeping;

  /**
   * Daily housekeeping exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dailyHousekeepingException;

  /**
   * Housekeeping available. Guest units are cleaned by hotel staff during guest's stay. Schedule
   * may vary from daily, weekly, or specific days of the week.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean housekeepingAvailable;

  /**
   * Housekeeping available exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String housekeepingAvailableException;

  /**
   * Turndown service. Hotel staff enters guest units to prepare the bed for sleep use. May or may
   * not include some light housekeeping. May or may not include an evening snack or candy. Also
   * known as evening service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean turndownService;

  /**
   * Turndown service exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String turndownServiceException;

  /**
   * Daily housekeeping. Guest units are cleaned by hotel staff daily during guest's stay.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDailyHousekeeping() {
    return dailyHousekeeping;
  }

  /**
   * Daily housekeeping. Guest units are cleaned by hotel staff daily during guest's stay.
   * @param dailyHousekeeping dailyHousekeeping or {@code null} for none
   */
  public Housekeeping setDailyHousekeeping(java.lang.Boolean dailyHousekeeping) {
    this.dailyHousekeeping = dailyHousekeeping;
    return this;
  }

  /**
   * Daily housekeeping exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getDailyHousekeepingException() {
    return dailyHousekeepingException;
  }

  /**
   * Daily housekeeping exception.
   * @param dailyHousekeepingException dailyHousekeepingException or {@code null} for none
   */
  public Housekeeping setDailyHousekeepingException(java.lang.String dailyHousekeepingException) {
    this.dailyHousekeepingException = dailyHousekeepingException;
    return this;
  }

  /**
   * Housekeeping available. Guest units are cleaned by hotel staff during guest's stay. Schedule
   * may vary from daily, weekly, or specific days of the week.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHousekeepingAvailable() {
    return housekeepingAvailable;
  }

  /**
   * Housekeeping available. Guest units are cleaned by hotel staff during guest's stay. Schedule
   * may vary from daily, weekly, or specific days of the week.
   * @param housekeepingAvailable housekeepingAvailable or {@code null} for none
   */
  public Housekeeping setHousekeepingAvailable(java.lang.Boolean housekeepingAvailable) {
    this.housekeepingAvailable = housekeepingAvailable;
    return this;
  }

  /**
   * Housekeeping available exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getHousekeepingAvailableException() {
    return housekeepingAvailableException;
  }

  /**
   * Housekeeping available exception.
   * @param housekeepingAvailableException housekeepingAvailableException or {@code null} for none
   */
  public Housekeeping setHousekeepingAvailableException(java.lang.String housekeepingAvailableException) {
    this.housekeepingAvailableException = housekeepingAvailableException;
    return this;
  }

  /**
   * Turndown service. Hotel staff enters guest units to prepare the bed for sleep use. May or may
   * not include some light housekeeping. May or may not include an evening snack or candy. Also
   * known as evening service.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTurndownService() {
    return turndownService;
  }

  /**
   * Turndown service. Hotel staff enters guest units to prepare the bed for sleep use. May or may
   * not include some light housekeeping. May or may not include an evening snack or candy. Also
   * known as evening service.
   * @param turndownService turndownService or {@code null} for none
   */
  public Housekeeping setTurndownService(java.lang.Boolean turndownService) {
    this.turndownService = turndownService;
    return this;
  }

  /**
   * Turndown service exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getTurndownServiceException() {
    return turndownServiceException;
  }

  /**
   * Turndown service exception.
   * @param turndownServiceException turndownServiceException or {@code null} for none
   */
  public Housekeeping setTurndownServiceException(java.lang.String turndownServiceException) {
    this.turndownServiceException = turndownServiceException;
    return this;
  }

  @Override
  public Housekeeping set(String fieldName, Object value) {
    return (Housekeeping) super.set(fieldName, value);
  }

  @Override
  public Housekeeping clone() {
    return (Housekeeping) super.clone();
  }

}
