/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for InsuranceNetworkService.ListInsuranceNetworks
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListInsuranceNetworksResponse extends com.google.api.client.json.GenericJson {

  /**
   * A list of insurance networks that are supported by Google.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InsuranceNetwork> networks;

  /**
   * If there are more insurance networks than the requested page size, then this field is populated
   * with a token to fetch the next page of insurance networks on a subsequent call to
   * ListInsuranceNetworks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * A list of insurance networks that are supported by Google.
   * @return value or {@code null} for none
   */
  public java.util.List<InsuranceNetwork> getNetworks() {
    return networks;
  }

  /**
   * A list of insurance networks that are supported by Google.
   * @param networks networks or {@code null} for none
   */
  public ListInsuranceNetworksResponse setNetworks(java.util.List<InsuranceNetwork> networks) {
    this.networks = networks;
    return this;
  }

  /**
   * If there are more insurance networks than the requested page size, then this field is populated
   * with a token to fetch the next page of insurance networks on a subsequent call to
   * ListInsuranceNetworks.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If there are more insurance networks than the requested page size, then this field is populated
   * with a token to fetch the next page of insurance networks on a subsequent call to
   * ListInsuranceNetworks.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListInsuranceNetworksResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListInsuranceNetworksResponse set(String fieldName, Object value) {
    return (ListInsuranceNetworksResponse) super.set(fieldName, value);
  }

  @Override
  public ListInsuranceNetworksResponse clone() {
    return (ListInsuranceNetworksResponse) super.clone();
  }

}
