/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Contains a set of booleans that reflect the [state of a
 * Location.](https://support.google.com/business/answer/3480862)
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocationState extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Indicates whether the location can be deleted using the Google My Business API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canDelete;

  /**
   * Output only. Indicates if the listing is eligible for food menu.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canHaveFoodMenus;

  /**
   * Output only. Indicates if the listing can modify a ServiceList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canModifyServiceList;

  /**
   * Output only. Indicates whether the location can operate on Health data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canOperateHealthData;

  /**
   * Output only. Indicates whether the location can operate on Lodging data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canOperateLodgingData;

  /**
   * Output only. Indicates whether the location can be updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canUpdate;

  /**
   * Output only. Indicates whether any of this Location's properties are in the edit pending state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasPendingEdits;

  /**
   * Output only. Indicates whether the location has pending verification requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasPendingVerification;

  /**
   * Output only. Indicates whether the location is disabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isDisabled;

  /**
   * Output only. Indicates whether the location is disconnected from a place on Google Maps.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isDisconnected;

  /**
   * Output only. Indicates whether the location is a duplicate of another location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isDuplicate;

  /**
   * Output only. Indicates whether the place ID associated with this location has updates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isGoogleUpdated;

  /**
   * Output only. Indicates whether [accounts.locations.localPosts](/my-
   * business/reference/rest/v4/accounts.locations.localPosts) is disabled for this location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isLocalPostApiDisabled;

  /**
   * Output only. Indicates whether the review of the location is pending.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isPendingReview;

  /**
   * Output only. Indicates whether the location is published.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isPublished;

  /**
   * Output only. Indicates whether the location is suspended. Suspended locations are not visible
   * to end users in Google products. If you believe this was a mistake, see the [help center
   * article] (https://support.google.com/business/answer/4569145).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isSuspended;

  /**
   * Output only. Indicates whether the location is verified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isVerified;

  /**
   * Output only. Indicates whether the location requires reverification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean needsReverification;

  /**
   * Output only. Indicates whether the location can be deleted using the Google My Business API.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanDelete() {
    return canDelete;
  }

  /**
   * Output only. Indicates whether the location can be deleted using the Google My Business API.
   * @param canDelete canDelete or {@code null} for none
   */
  public LocationState setCanDelete(java.lang.Boolean canDelete) {
    this.canDelete = canDelete;
    return this;
  }

  /**
   * Output only. Indicates if the listing is eligible for food menu.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanHaveFoodMenus() {
    return canHaveFoodMenus;
  }

  /**
   * Output only. Indicates if the listing is eligible for food menu.
   * @param canHaveFoodMenus canHaveFoodMenus or {@code null} for none
   */
  public LocationState setCanHaveFoodMenus(java.lang.Boolean canHaveFoodMenus) {
    this.canHaveFoodMenus = canHaveFoodMenus;
    return this;
  }

  /**
   * Output only. Indicates if the listing can modify a ServiceList.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanModifyServiceList() {
    return canModifyServiceList;
  }

  /**
   * Output only. Indicates if the listing can modify a ServiceList.
   * @param canModifyServiceList canModifyServiceList or {@code null} for none
   */
  public LocationState setCanModifyServiceList(java.lang.Boolean canModifyServiceList) {
    this.canModifyServiceList = canModifyServiceList;
    return this;
  }

  /**
   * Output only. Indicates whether the location can operate on Health data.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanOperateHealthData() {
    return canOperateHealthData;
  }

  /**
   * Output only. Indicates whether the location can operate on Health data.
   * @param canOperateHealthData canOperateHealthData or {@code null} for none
   */
  public LocationState setCanOperateHealthData(java.lang.Boolean canOperateHealthData) {
    this.canOperateHealthData = canOperateHealthData;
    return this;
  }

  /**
   * Output only. Indicates whether the location can operate on Lodging data.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanOperateLodgingData() {
    return canOperateLodgingData;
  }

  /**
   * Output only. Indicates whether the location can operate on Lodging data.
   * @param canOperateLodgingData canOperateLodgingData or {@code null} for none
   */
  public LocationState setCanOperateLodgingData(java.lang.Boolean canOperateLodgingData) {
    this.canOperateLodgingData = canOperateLodgingData;
    return this;
  }

  /**
   * Output only. Indicates whether the location can be updated.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanUpdate() {
    return canUpdate;
  }

  /**
   * Output only. Indicates whether the location can be updated.
   * @param canUpdate canUpdate or {@code null} for none
   */
  public LocationState setCanUpdate(java.lang.Boolean canUpdate) {
    this.canUpdate = canUpdate;
    return this;
  }

  /**
   * Output only. Indicates whether any of this Location's properties are in the edit pending state.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasPendingEdits() {
    return hasPendingEdits;
  }

  /**
   * Output only. Indicates whether any of this Location's properties are in the edit pending state.
   * @param hasPendingEdits hasPendingEdits or {@code null} for none
   */
  public LocationState setHasPendingEdits(java.lang.Boolean hasPendingEdits) {
    this.hasPendingEdits = hasPendingEdits;
    return this;
  }

  /**
   * Output only. Indicates whether the location has pending verification requests.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasPendingVerification() {
    return hasPendingVerification;
  }

  /**
   * Output only. Indicates whether the location has pending verification requests.
   * @param hasPendingVerification hasPendingVerification or {@code null} for none
   */
  public LocationState setHasPendingVerification(java.lang.Boolean hasPendingVerification) {
    this.hasPendingVerification = hasPendingVerification;
    return this;
  }

  /**
   * Output only. Indicates whether the location is disabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsDisabled() {
    return isDisabled;
  }

  /**
   * Output only. Indicates whether the location is disabled.
   * @param isDisabled isDisabled or {@code null} for none
   */
  public LocationState setIsDisabled(java.lang.Boolean isDisabled) {
    this.isDisabled = isDisabled;
    return this;
  }

  /**
   * Output only. Indicates whether the location is disconnected from a place on Google Maps.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsDisconnected() {
    return isDisconnected;
  }

  /**
   * Output only. Indicates whether the location is disconnected from a place on Google Maps.
   * @param isDisconnected isDisconnected or {@code null} for none
   */
  public LocationState setIsDisconnected(java.lang.Boolean isDisconnected) {
    this.isDisconnected = isDisconnected;
    return this;
  }

  /**
   * Output only. Indicates whether the location is a duplicate of another location.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsDuplicate() {
    return isDuplicate;
  }

  /**
   * Output only. Indicates whether the location is a duplicate of another location.
   * @param isDuplicate isDuplicate or {@code null} for none
   */
  public LocationState setIsDuplicate(java.lang.Boolean isDuplicate) {
    this.isDuplicate = isDuplicate;
    return this;
  }

  /**
   * Output only. Indicates whether the place ID associated with this location has updates.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsGoogleUpdated() {
    return isGoogleUpdated;
  }

  /**
   * Output only. Indicates whether the place ID associated with this location has updates.
   * @param isGoogleUpdated isGoogleUpdated or {@code null} for none
   */
  public LocationState setIsGoogleUpdated(java.lang.Boolean isGoogleUpdated) {
    this.isGoogleUpdated = isGoogleUpdated;
    return this;
  }

  /**
   * Output only. Indicates whether [accounts.locations.localPosts](/my-
   * business/reference/rest/v4/accounts.locations.localPosts) is disabled for this location.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsLocalPostApiDisabled() {
    return isLocalPostApiDisabled;
  }

  /**
   * Output only. Indicates whether [accounts.locations.localPosts](/my-
   * business/reference/rest/v4/accounts.locations.localPosts) is disabled for this location.
   * @param isLocalPostApiDisabled isLocalPostApiDisabled or {@code null} for none
   */
  public LocationState setIsLocalPostApiDisabled(java.lang.Boolean isLocalPostApiDisabled) {
    this.isLocalPostApiDisabled = isLocalPostApiDisabled;
    return this;
  }

  /**
   * Output only. Indicates whether the review of the location is pending.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsPendingReview() {
    return isPendingReview;
  }

  /**
   * Output only. Indicates whether the review of the location is pending.
   * @param isPendingReview isPendingReview or {@code null} for none
   */
  public LocationState setIsPendingReview(java.lang.Boolean isPendingReview) {
    this.isPendingReview = isPendingReview;
    return this;
  }

  /**
   * Output only. Indicates whether the location is published.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsPublished() {
    return isPublished;
  }

  /**
   * Output only. Indicates whether the location is published.
   * @param isPublished isPublished or {@code null} for none
   */
  public LocationState setIsPublished(java.lang.Boolean isPublished) {
    this.isPublished = isPublished;
    return this;
  }

  /**
   * Output only. Indicates whether the location is suspended. Suspended locations are not visible
   * to end users in Google products. If you believe this was a mistake, see the [help center
   * article] (https://support.google.com/business/answer/4569145).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsSuspended() {
    return isSuspended;
  }

  /**
   * Output only. Indicates whether the location is suspended. Suspended locations are not visible
   * to end users in Google products. If you believe this was a mistake, see the [help center
   * article] (https://support.google.com/business/answer/4569145).
   * @param isSuspended isSuspended or {@code null} for none
   */
  public LocationState setIsSuspended(java.lang.Boolean isSuspended) {
    this.isSuspended = isSuspended;
    return this;
  }

  /**
   * Output only. Indicates whether the location is verified.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsVerified() {
    return isVerified;
  }

  /**
   * Output only. Indicates whether the location is verified.
   * @param isVerified isVerified or {@code null} for none
   */
  public LocationState setIsVerified(java.lang.Boolean isVerified) {
    this.isVerified = isVerified;
    return this;
  }

  /**
   * Output only. Indicates whether the location requires reverification.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNeedsReverification() {
    return needsReverification;
  }

  /**
   * Output only. Indicates whether the location requires reverification.
   * @param needsReverification needsReverification or {@code null} for none
   */
  public LocationState setNeedsReverification(java.lang.Boolean needsReverification) {
    this.needsReverification = needsReverification;
    return this;
  }

  @Override
  public LocationState set(String fieldName, Object value) {
    return (LocationState) super.set(fieldName, value);
  }

  @Override
  public LocationState clone() {
    return (LocationState) super.clone();
  }

}
