/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Attribution information for customer media items, such as the contributor's name and profile
 * picture.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Attribution extends com.google.api.client.json.GenericJson {

  /**
   * The user name to attribute the media item to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profileName;

  /**
   * URL of the attributed user's profile photo thumbnail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profilePhotoUrl;

  /**
   * The URL of the attributed user's Google Maps profile page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profileUrl;

  /**
   * The URL of the takedown page, where the media item can be reported if it is inappropriate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String takedownUrl;

  /**
   * The user name to attribute the media item to.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfileName() {
    return profileName;
  }

  /**
   * The user name to attribute the media item to.
   * @param profileName profileName or {@code null} for none
   */
  public Attribution setProfileName(java.lang.String profileName) {
    this.profileName = profileName;
    return this;
  }

  /**
   * URL of the attributed user's profile photo thumbnail.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfilePhotoUrl() {
    return profilePhotoUrl;
  }

  /**
   * URL of the attributed user's profile photo thumbnail.
   * @param profilePhotoUrl profilePhotoUrl or {@code null} for none
   */
  public Attribution setProfilePhotoUrl(java.lang.String profilePhotoUrl) {
    this.profilePhotoUrl = profilePhotoUrl;
    return this;
  }

  /**
   * The URL of the attributed user's Google Maps profile page.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfileUrl() {
    return profileUrl;
  }

  /**
   * The URL of the attributed user's Google Maps profile page.
   * @param profileUrl profileUrl or {@code null} for none
   */
  public Attribution setProfileUrl(java.lang.String profileUrl) {
    this.profileUrl = profileUrl;
    return this;
  }

  /**
   * The URL of the takedown page, where the media item can be reported if it is inappropriate.
   * @return value or {@code null} for none
   */
  public java.lang.String getTakedownUrl() {
    return takedownUrl;
  }

  /**
   * The URL of the takedown page, where the media item can be reported if it is inappropriate.
   * @param takedownUrl takedownUrl or {@code null} for none
   */
  public Attribution setTakedownUrl(java.lang.String takedownUrl) {
    this.takedownUrl = takedownUrl;
    return this;
  }

  @Override
  public Attribution set(String fieldName, Object value) {
    return (Attribution) super.set(fieldName, value);
  }

  @Override
  public Attribution clone() {
    return (Attribution) super.clone();
  }

}
