/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A value for a single Metric from a starting time.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MetricValue extends com.google.api.client.json.GenericJson {

  /**
   * Dimensional values for this metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DimensionalMetricValue> dimensionalValues;

  /**
   * The metric for which the value applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metric;

  /**
   * The total aggregated value for this metric. Set for the AGGREGATED_TOTAL option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionalMetricValue totalValue;

  /**
   * Dimensional values for this metric.
   * @return value or {@code null} for none
   */
  public java.util.List<DimensionalMetricValue> getDimensionalValues() {
    return dimensionalValues;
  }

  /**
   * Dimensional values for this metric.
   * @param dimensionalValues dimensionalValues or {@code null} for none
   */
  public MetricValue setDimensionalValues(java.util.List<DimensionalMetricValue> dimensionalValues) {
    this.dimensionalValues = dimensionalValues;
    return this;
  }

  /**
   * The metric for which the value applies.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetric() {
    return metric;
  }

  /**
   * The metric for which the value applies.
   * @param metric metric or {@code null} for none
   */
  public MetricValue setMetric(java.lang.String metric) {
    this.metric = metric;
    return this;
  }

  /**
   * The total aggregated value for this metric. Set for the AGGREGATED_TOTAL option.
   * @return value or {@code null} for none
   */
  public DimensionalMetricValue getTotalValue() {
    return totalValue;
  }

  /**
   * The total aggregated value for this metric. Set for the AGGREGATED_TOTAL option.
   * @param totalValue totalValue or {@code null} for none
   */
  public MetricValue setTotalValue(DimensionalMetricValue totalValue) {
    this.totalValue = totalValue;
    return this;
  }

  @Override
  public MetricValue set(String fieldName, Object value) {
    return (MetricValue) super.set(fieldName, value);
  }

  @Override
  public MetricValue clone() {
    return (MetricValue) super.clone();
  }

}
