/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Request message for GoogleLocations.SearchGoogleLocations.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SearchGoogleLocationsRequest extends com.google.api.client.json.GenericJson {

  /**
   * Location to search for. If provided, will find locations which match the provided location
   * details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location location;

  /**
   * Text query to search for. The search results from a query string will be less accurate than if
   * providing an exact location, but can provide more inexact matches.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String query;

  /**
   * The number of matches to return. The default value is 3, with a maximum of 10. Note that
   * latency may increase if more are requested. There is no pagination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer resultCount;

  /**
   * Location to search for. If provided, will find locations which match the provided location
   * details.
   * @return value or {@code null} for none
   */
  public Location getLocation() {
    return location;
  }

  /**
   * Location to search for. If provided, will find locations which match the provided location
   * details.
   * @param location location or {@code null} for none
   */
  public SearchGoogleLocationsRequest setLocation(Location location) {
    this.location = location;
    return this;
  }

  /**
   * Text query to search for. The search results from a query string will be less accurate than if
   * providing an exact location, but can provide more inexact matches.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuery() {
    return query;
  }

  /**
   * Text query to search for. The search results from a query string will be less accurate than if
   * providing an exact location, but can provide more inexact matches.
   * @param query query or {@code null} for none
   */
  public SearchGoogleLocationsRequest setQuery(java.lang.String query) {
    this.query = query;
    return this;
  }

  /**
   * The number of matches to return. The default value is 3, with a maximum of 10. Note that
   * latency may increase if more are requested. There is no pagination.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getResultCount() {
    return resultCount;
  }

  /**
   * The number of matches to return. The default value is 3, with a maximum of 10. Note that
   * latency may increase if more are requested. There is no pagination.
   * @param resultCount resultCount or {@code null} for none
   */
  public SearchGoogleLocationsRequest setResultCount(java.lang.Integer resultCount) {
    this.resultCount = resultCount;
    return this;
  }

  @Override
  public SearchGoogleLocationsRequest set(String fieldName, Object value) {
    return (SearchGoogleLocationsRequest) super.set(fieldName, value);
  }

  @Override
  public SearchGoogleLocationsRequest clone() {
    return (SearchGoogleLocationsRequest) super.clone();
  }

}
