/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Swimming pool or recreational water facilities available at the hotel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Pools extends com.google.api.client.json.GenericJson {

  /**
   * Adult pool. A pool restricted for use by adults only. Can be indoors or outdoors.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adultPool;

  /**
   * Adult pool exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adultPoolException;

  /**
   * Hot tub. A man-made pool containing bubbling water maintained at a higher temperature and
   * circulated by aerating jets for the purpose of soaking, relaxation and hydrotherapy. Can be
   * indoors or outdoors. Not used for active swimming. Also known as Jacuzzi. Hot tub must be in a
   * common area where all guests can access it. Does not apply to room-specific hot tubs that are
   * only accessible to guest occupying that room.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hotTub;

  /**
   * Hot tub exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hotTubException;

  /**
   * Indoor pool. A pool located inside the hotel and available for guests to use for swimming
   * and/or soaking. Use may or may not be restricted to adults and/or children.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean indoorPool;

  /**
   * Indoor pool exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String indoorPoolException;

  /**
   * Indoor pools count. The sum of all indoor pools at the hotel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer indoorPoolsCount;

  /**
   * Indoor pools count exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String indoorPoolsCountException;

  /**
   * Lazy river. A man-made pool or several interconnected recreational pools built to mimic the
   * shape and current of a winding river where guests float in the water on inflated rubber tubes.
   * Can be indoors or outdoors.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean lazyRiver;

  /**
   * Lazy river exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lazyRiverException;

  /**
   * Lifeguard. A trained member of the hotel staff stationed by the hotel's indoor or outdoor
   * swimming area and responsible for the safety of swimming guests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean lifeguard;

  /**
   * Lifeguard exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lifeguardException;

  /**
   * Outdoor pool. A pool located outside on the grounds of the hotel and available for guests to
   * use for swimming, soaking or recreation. Use may or may not be restricted to adults and/or
   * children.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean outdoorPool;

  /**
   * Outdoor pool exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String outdoorPoolException;

  /**
   * Outdoor pools count. The sum of all outdoor pools at the hotel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer outdoorPoolsCount;

  /**
   * Outdoor pools count exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String outdoorPoolsCountException;

  /**
   * Pool. The presence of a pool, either indoors or outdoors, for guests to use for swimming and/or
   * soaking. Use may or may not be restricted to adults and/or children.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean pool;

  /**
   * Pool exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String poolException;

  /**
   * Pools count. The sum of all pools at the hotel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer poolsCount;

  /**
   * Pools count exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String poolsCountException;

  /**
   * Wading pool. A shallow pool designed for small children to play in. Can be indoors or outdoors.
   * Also known as kiddie pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean wadingPool;

  /**
   * Wading pool exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String wadingPoolException;

  /**
   * Water park. An aquatic recreation area with a large pool or series of pools that has features
   * such as a water slide or tube, wavepool, fountains, rope swings, and/or obstacle course. Can be
   * indoors or outdoors. Also known as adventure pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean waterPark;

  /**
   * Water park exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String waterParkException;

  /**
   * Waterslide. A continuously wetted chute positioned by an indoor or outdoor pool which people
   * slide down into the water.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean waterslide;

  /**
   * Waterslide exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String waterslideException;

  /**
   * Wave pool. A large indoor or outdoor pool with a machine that produces water currents to mimic
   * the ocean's crests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean wavePool;

  /**
   * Wave pool exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String wavePoolException;

  /**
   * Adult pool. A pool restricted for use by adults only. Can be indoors or outdoors.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdultPool() {
    return adultPool;
  }

  /**
   * Adult pool. A pool restricted for use by adults only. Can be indoors or outdoors.
   * @param adultPool adultPool or {@code null} for none
   */
  public Pools setAdultPool(java.lang.Boolean adultPool) {
    this.adultPool = adultPool;
    return this;
  }

  /**
   * Adult pool exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdultPoolException() {
    return adultPoolException;
  }

  /**
   * Adult pool exception.
   * @param adultPoolException adultPoolException or {@code null} for none
   */
  public Pools setAdultPoolException(java.lang.String adultPoolException) {
    this.adultPoolException = adultPoolException;
    return this;
  }

  /**
   * Hot tub. A man-made pool containing bubbling water maintained at a higher temperature and
   * circulated by aerating jets for the purpose of soaking, relaxation and hydrotherapy. Can be
   * indoors or outdoors. Not used for active swimming. Also known as Jacuzzi. Hot tub must be in a
   * common area where all guests can access it. Does not apply to room-specific hot tubs that are
   * only accessible to guest occupying that room.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHotTub() {
    return hotTub;
  }

  /**
   * Hot tub. A man-made pool containing bubbling water maintained at a higher temperature and
   * circulated by aerating jets for the purpose of soaking, relaxation and hydrotherapy. Can be
   * indoors or outdoors. Not used for active swimming. Also known as Jacuzzi. Hot tub must be in a
   * common area where all guests can access it. Does not apply to room-specific hot tubs that are
   * only accessible to guest occupying that room.
   * @param hotTub hotTub or {@code null} for none
   */
  public Pools setHotTub(java.lang.Boolean hotTub) {
    this.hotTub = hotTub;
    return this;
  }

  /**
   * Hot tub exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getHotTubException() {
    return hotTubException;
  }

  /**
   * Hot tub exception.
   * @param hotTubException hotTubException or {@code null} for none
   */
  public Pools setHotTubException(java.lang.String hotTubException) {
    this.hotTubException = hotTubException;
    return this;
  }

  /**
   * Indoor pool. A pool located inside the hotel and available for guests to use for swimming
   * and/or soaking. Use may or may not be restricted to adults and/or children.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIndoorPool() {
    return indoorPool;
  }

  /**
   * Indoor pool. A pool located inside the hotel and available for guests to use for swimming
   * and/or soaking. Use may or may not be restricted to adults and/or children.
   * @param indoorPool indoorPool or {@code null} for none
   */
  public Pools setIndoorPool(java.lang.Boolean indoorPool) {
    this.indoorPool = indoorPool;
    return this;
  }

  /**
   * Indoor pool exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getIndoorPoolException() {
    return indoorPoolException;
  }

  /**
   * Indoor pool exception.
   * @param indoorPoolException indoorPoolException or {@code null} for none
   */
  public Pools setIndoorPoolException(java.lang.String indoorPoolException) {
    this.indoorPoolException = indoorPoolException;
    return this;
  }

  /**
   * Indoor pools count. The sum of all indoor pools at the hotel.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIndoorPoolsCount() {
    return indoorPoolsCount;
  }

  /**
   * Indoor pools count. The sum of all indoor pools at the hotel.
   * @param indoorPoolsCount indoorPoolsCount or {@code null} for none
   */
  public Pools setIndoorPoolsCount(java.lang.Integer indoorPoolsCount) {
    this.indoorPoolsCount = indoorPoolsCount;
    return this;
  }

  /**
   * Indoor pools count exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getIndoorPoolsCountException() {
    return indoorPoolsCountException;
  }

  /**
   * Indoor pools count exception.
   * @param indoorPoolsCountException indoorPoolsCountException or {@code null} for none
   */
  public Pools setIndoorPoolsCountException(java.lang.String indoorPoolsCountException) {
    this.indoorPoolsCountException = indoorPoolsCountException;
    return this;
  }

  /**
   * Lazy river. A man-made pool or several interconnected recreational pools built to mimic the
   * shape and current of a winding river where guests float in the water on inflated rubber tubes.
   * Can be indoors or outdoors.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLazyRiver() {
    return lazyRiver;
  }

  /**
   * Lazy river. A man-made pool or several interconnected recreational pools built to mimic the
   * shape and current of a winding river where guests float in the water on inflated rubber tubes.
   * Can be indoors or outdoors.
   * @param lazyRiver lazyRiver or {@code null} for none
   */
  public Pools setLazyRiver(java.lang.Boolean lazyRiver) {
    this.lazyRiver = lazyRiver;
    return this;
  }

  /**
   * Lazy river exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getLazyRiverException() {
    return lazyRiverException;
  }

  /**
   * Lazy river exception.
   * @param lazyRiverException lazyRiverException or {@code null} for none
   */
  public Pools setLazyRiverException(java.lang.String lazyRiverException) {
    this.lazyRiverException = lazyRiverException;
    return this;
  }

  /**
   * Lifeguard. A trained member of the hotel staff stationed by the hotel's indoor or outdoor
   * swimming area and responsible for the safety of swimming guests.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLifeguard() {
    return lifeguard;
  }

  /**
   * Lifeguard. A trained member of the hotel staff stationed by the hotel's indoor or outdoor
   * swimming area and responsible for the safety of swimming guests.
   * @param lifeguard lifeguard or {@code null} for none
   */
  public Pools setLifeguard(java.lang.Boolean lifeguard) {
    this.lifeguard = lifeguard;
    return this;
  }

  /**
   * Lifeguard exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getLifeguardException() {
    return lifeguardException;
  }

  /**
   * Lifeguard exception.
   * @param lifeguardException lifeguardException or {@code null} for none
   */
  public Pools setLifeguardException(java.lang.String lifeguardException) {
    this.lifeguardException = lifeguardException;
    return this;
  }

  /**
   * Outdoor pool. A pool located outside on the grounds of the hotel and available for guests to
   * use for swimming, soaking or recreation. Use may or may not be restricted to adults and/or
   * children.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOutdoorPool() {
    return outdoorPool;
  }

  /**
   * Outdoor pool. A pool located outside on the grounds of the hotel and available for guests to
   * use for swimming, soaking or recreation. Use may or may not be restricted to adults and/or
   * children.
   * @param outdoorPool outdoorPool or {@code null} for none
   */
  public Pools setOutdoorPool(java.lang.Boolean outdoorPool) {
    this.outdoorPool = outdoorPool;
    return this;
  }

  /**
   * Outdoor pool exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getOutdoorPoolException() {
    return outdoorPoolException;
  }

  /**
   * Outdoor pool exception.
   * @param outdoorPoolException outdoorPoolException or {@code null} for none
   */
  public Pools setOutdoorPoolException(java.lang.String outdoorPoolException) {
    this.outdoorPoolException = outdoorPoolException;
    return this;
  }

  /**
   * Outdoor pools count. The sum of all outdoor pools at the hotel.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOutdoorPoolsCount() {
    return outdoorPoolsCount;
  }

  /**
   * Outdoor pools count. The sum of all outdoor pools at the hotel.
   * @param outdoorPoolsCount outdoorPoolsCount or {@code null} for none
   */
  public Pools setOutdoorPoolsCount(java.lang.Integer outdoorPoolsCount) {
    this.outdoorPoolsCount = outdoorPoolsCount;
    return this;
  }

  /**
   * Outdoor pools count exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getOutdoorPoolsCountException() {
    return outdoorPoolsCountException;
  }

  /**
   * Outdoor pools count exception.
   * @param outdoorPoolsCountException outdoorPoolsCountException or {@code null} for none
   */
  public Pools setOutdoorPoolsCountException(java.lang.String outdoorPoolsCountException) {
    this.outdoorPoolsCountException = outdoorPoolsCountException;
    return this;
  }

  /**
   * Pool. The presence of a pool, either indoors or outdoors, for guests to use for swimming and/or
   * soaking. Use may or may not be restricted to adults and/or children.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPool() {
    return pool;
  }

  /**
   * Pool. The presence of a pool, either indoors or outdoors, for guests to use for swimming and/or
   * soaking. Use may or may not be restricted to adults and/or children.
   * @param pool pool or {@code null} for none
   */
  public Pools setPool(java.lang.Boolean pool) {
    this.pool = pool;
    return this;
  }

  /**
   * Pool exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getPoolException() {
    return poolException;
  }

  /**
   * Pool exception.
   * @param poolException poolException or {@code null} for none
   */
  public Pools setPoolException(java.lang.String poolException) {
    this.poolException = poolException;
    return this;
  }

  /**
   * Pools count. The sum of all pools at the hotel.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPoolsCount() {
    return poolsCount;
  }

  /**
   * Pools count. The sum of all pools at the hotel.
   * @param poolsCount poolsCount or {@code null} for none
   */
  public Pools setPoolsCount(java.lang.Integer poolsCount) {
    this.poolsCount = poolsCount;
    return this;
  }

  /**
   * Pools count exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getPoolsCountException() {
    return poolsCountException;
  }

  /**
   * Pools count exception.
   * @param poolsCountException poolsCountException or {@code null} for none
   */
  public Pools setPoolsCountException(java.lang.String poolsCountException) {
    this.poolsCountException = poolsCountException;
    return this;
  }

  /**
   * Wading pool. A shallow pool designed for small children to play in. Can be indoors or outdoors.
   * Also known as kiddie pool.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWadingPool() {
    return wadingPool;
  }

  /**
   * Wading pool. A shallow pool designed for small children to play in. Can be indoors or outdoors.
   * Also known as kiddie pool.
   * @param wadingPool wadingPool or {@code null} for none
   */
  public Pools setWadingPool(java.lang.Boolean wadingPool) {
    this.wadingPool = wadingPool;
    return this;
  }

  /**
   * Wading pool exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getWadingPoolException() {
    return wadingPoolException;
  }

  /**
   * Wading pool exception.
   * @param wadingPoolException wadingPoolException or {@code null} for none
   */
  public Pools setWadingPoolException(java.lang.String wadingPoolException) {
    this.wadingPoolException = wadingPoolException;
    return this;
  }

  /**
   * Water park. An aquatic recreation area with a large pool or series of pools that has features
   * such as a water slide or tube, wavepool, fountains, rope swings, and/or obstacle course. Can be
   * indoors or outdoors. Also known as adventure pool.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWaterPark() {
    return waterPark;
  }

  /**
   * Water park. An aquatic recreation area with a large pool or series of pools that has features
   * such as a water slide or tube, wavepool, fountains, rope swings, and/or obstacle course. Can be
   * indoors or outdoors. Also known as adventure pool.
   * @param waterPark waterPark or {@code null} for none
   */
  public Pools setWaterPark(java.lang.Boolean waterPark) {
    this.waterPark = waterPark;
    return this;
  }

  /**
   * Water park exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getWaterParkException() {
    return waterParkException;
  }

  /**
   * Water park exception.
   * @param waterParkException waterParkException or {@code null} for none
   */
  public Pools setWaterParkException(java.lang.String waterParkException) {
    this.waterParkException = waterParkException;
    return this;
  }

  /**
   * Waterslide. A continuously wetted chute positioned by an indoor or outdoor pool which people
   * slide down into the water.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWaterslide() {
    return waterslide;
  }

  /**
   * Waterslide. A continuously wetted chute positioned by an indoor or outdoor pool which people
   * slide down into the water.
   * @param waterslide waterslide or {@code null} for none
   */
  public Pools setWaterslide(java.lang.Boolean waterslide) {
    this.waterslide = waterslide;
    return this;
  }

  /**
   * Waterslide exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getWaterslideException() {
    return waterslideException;
  }

  /**
   * Waterslide exception.
   * @param waterslideException waterslideException or {@code null} for none
   */
  public Pools setWaterslideException(java.lang.String waterslideException) {
    this.waterslideException = waterslideException;
    return this;
  }

  /**
   * Wave pool. A large indoor or outdoor pool with a machine that produces water currents to mimic
   * the ocean's crests.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWavePool() {
    return wavePool;
  }

  /**
   * Wave pool. A large indoor or outdoor pool with a machine that produces water currents to mimic
   * the ocean's crests.
   * @param wavePool wavePool or {@code null} for none
   */
  public Pools setWavePool(java.lang.Boolean wavePool) {
    this.wavePool = wavePool;
    return this;
  }

  /**
   * Wave pool exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getWavePoolException() {
    return wavePoolException;
  }

  /**
   * Wave pool exception.
   * @param wavePoolException wavePoolException or {@code null} for none
   */
  public Pools setWavePoolException(java.lang.String wavePoolException) {
    this.wavePoolException = wavePoolException;
    return this;
  }

  @Override
  public Pools set(String fieldName, Object value) {
    return (Pools) super.set(fieldName, value);
  }

  @Override
  public Pools clone() {
    return (Pools) super.clone();
  }

}
