/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Request message for Insights.ReportLocalPostInsights
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportLocalPostInsightsRequest extends com.google.api.client.json.GenericJson {

  /**
   * A request to include basic metric insights in the report. This request applies to all posts
   * requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BasicMetricsRequest basicRequest;

  /**
   * Required. The list of posts for which to fetch insights data. All posts have to belong to the
   * location whose name is specified in the `name` field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> localPostNames;

  /**
   * A request to include basic metric insights in the report. This request applies to all posts
   * requested.
   * @return value or {@code null} for none
   */
  public BasicMetricsRequest getBasicRequest() {
    return basicRequest;
  }

  /**
   * A request to include basic metric insights in the report. This request applies to all posts
   * requested.
   * @param basicRequest basicRequest or {@code null} for none
   */
  public ReportLocalPostInsightsRequest setBasicRequest(BasicMetricsRequest basicRequest) {
    this.basicRequest = basicRequest;
    return this;
  }

  /**
   * Required. The list of posts for which to fetch insights data. All posts have to belong to the
   * location whose name is specified in the `name` field.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLocalPostNames() {
    return localPostNames;
  }

  /**
   * Required. The list of posts for which to fetch insights data. All posts have to belong to the
   * location whose name is specified in the `name` field.
   * @param localPostNames localPostNames or {@code null} for none
   */
  public ReportLocalPostInsightsRequest setLocalPostNames(java.util.List<java.lang.String> localPostNames) {
    this.localPostNames = localPostNames;
    return this;
  }

  @Override
  public ReportLocalPostInsightsRequest set(String fieldName, Object value) {
    return (ReportLocalPostInsightsRequest) super.set(fieldName, value);
  }

  @Override
  public ReportLocalPostInsightsRequest clone() {
    return (ReportLocalPostInsightsRequest) super.clone();
  }

}
