/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for Insights.ReportLocalPostInsights
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportLocalPostInsightsResponse extends com.google.api.client.json.GenericJson {

  /**
   * One entry per requested post corresponding to this location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LocalPostMetrics> localPostMetrics;

  static {
    // hack to force ProGuard to consider LocalPostMetrics used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LocalPostMetrics.class);
  }

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Time zone (IANA timezone IDs, eg, 'Europe/London') of the location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * One entry per requested post corresponding to this location.
   * @return value or {@code null} for none
   */
  public java.util.List<LocalPostMetrics> getLocalPostMetrics() {
    return localPostMetrics;
  }

  /**
   * One entry per requested post corresponding to this location.
   * @param localPostMetrics localPostMetrics or {@code null} for none
   */
  public ReportLocalPostInsightsResponse setLocalPostMetrics(java.util.List<LocalPostMetrics> localPostMetrics) {
    this.localPostMetrics = localPostMetrics;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * @param name name or {@code null} for none
   */
  public ReportLocalPostInsightsResponse setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Time zone (IANA timezone IDs, eg, 'Europe/London') of the location.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * Time zone (IANA timezone IDs, eg, 'Europe/London') of the location.
   * @param timeZone timeZone or {@code null} for none
   */
  public ReportLocalPostInsightsResponse setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  @Override
  public ReportLocalPostInsightsResponse set(String fieldName, Object value) {
    return (ReportLocalPostInsightsResponse) super.set(fieldName, value);
  }

  @Override
  public ReportLocalPostInsightsResponse clone() {
    return (ReportLocalPostInsightsResponse) super.clone();
  }

}
