/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A message describing a service type that the business offers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceType extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The human-readable display name for the service type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. A stable ID (provided by Google) for this service type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serviceTypeId;

  /**
   * Output only. The human-readable display name for the service type.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Output only. The human-readable display name for the service type.
   * @param displayName displayName or {@code null} for none
   */
  public ServiceType setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. A stable ID (provided by Google) for this service type.
   * @return value or {@code null} for none
   */
  public java.lang.String getServiceTypeId() {
    return serviceTypeId;
  }

  /**
   * Output only. A stable ID (provided by Google) for this service type.
   * @param serviceTypeId serviceTypeId or {@code null} for none
   */
  public ServiceType setServiceTypeId(java.lang.String serviceTypeId) {
    this.serviceTypeId = serviceTypeId;
    return this;
  }

  @Override
  public ServiceType set(String fieldName, Object value) {
    return (ServiceType) super.set(fieldName, value);
  }

  @Override
  public ServiceType clone() {
    return (ServiceType) super.clone();
  }

}
