// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.pay.echo.inbound.controller;

import com.google.pay.echo.inbound.service.InboundEchoService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InboundEchoController {

  private final InboundEchoService inboundEchoService;

  public InboundEchoController(InboundEchoService inboundEchoService) {
    this.inboundEchoService = inboundEchoService;
  }

  /**
   * POST endpoint called by Google to test connectivity. Once the request is received it is
   * decrypted, and an encrypted response is returned.
   *
   * @param echoRequest The encrypted request body coming from Google.
   * @return An encrypted string.
   */
  @PostMapping("v2/echo")
  public ResponseEntity<String> echo(@RequestBody String echoRequest) {
    return inboundEchoService.decryptRequestAndEncryptEchoResponse(echoRequest);
  }
}
