// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.pay.echo.inbound.domain;

/**
 * Defines the echo response header in the echo response for the "/v2/echo" api.
 *
 * @see <a href=
 *     "https://developers.google.com/standard-payments/payment-integrator-diagnostic-api/Shared.Types/ErrorResponse#responseheader">
 *     Response Header </a>
 */
public class InboundResponseHeader {

  private Timestamp responseTimestamp;

  public InboundResponseHeader(Timestamp responseTimestamp) {
    this.responseTimestamp = responseTimestamp;
  }

  public Timestamp getResponseTimestamp() {
    return responseTimestamp;
  }

  public void setResponseTimestamp(Timestamp responseTimestamp) {
    this.responseTimestamp = responseTimestamp;
  }
}
