/**
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Utils to build the unencrypted request body 
 * Google Standard Payments' `echo` endpoint.
 * @param {string} message to be sent in the 'clientMessage' field to GSP
 */

const { v4: uuidv4 } = require('uuid');

var methods = {
    buildEchoRequestBody: function(message) {
        const bodyJson = {
            'requestHeader': {
                'protocolVersion': {
                    'major': 1,
                    'minor': 0,
                    'revision': 0,
                },
                'requestId': uuidv4(),
                'requestTimestamp': Date.now().toString(),
            },
            'clientMessage': message,
        };
        return JSON.stringify(bodyJson);
    },

    buildEchoResponseBody: function(message) {
        const bodyJson = {
            'responseHeader': {
                'responseTimestamp': { 'epochMillis': Date.now().toString() }
            },
            'clientMessage': message,
            'serverMessage': "Debug ID: " + uuidv4(),
        };
        return JSON.stringify(bodyJson);
    }
};

module.exports = methods;