Google Classroom add-ons NodeJS Examples
========================================

This project hosts web applications that demonstrate the implmentation of a
Google Classroom add-on using NodeJS.

This series of walkthroughs illustrates all the moving parts of a working
Classroom add-on. The walkthroughs have been designed to build upon the previous
walkthrough by layering in additional concepts and features.

Download the sample code for your language of choice and follow the setup
instructions below to have a running sample application. You can run each step
independently so that you can see a working app as the series progresses.

The files for each step of the walkthrough can be found in their own sub-folder.
(e.g. `./01-basic-app`, `./02-sign-in`, etc...) with common files found in the
top folder.

WARNING : NOT FOR PRODUCTION
----------------------------

This is a sample application for development purposes. You should follow best
practices when securing your production application and in particular how you
securely store and use OAuth tokens.

Review these resources for additional security considerations
*   [Google Identity developer website]
*   [OAuth 2.0 Security Best Current Practice]
*   [OAuth 2.0 Threat Model and Security Considerations]

[Google Identity developer website]: https://developers.google.com/identity
[OAuth 2.0 Security Best Current Practice]: https://datatracker.ietf.org/doc/html/draft-ietf-oauth-security-topics
[OAuth 2.0 Threat Model and Security Considerations]: https://datatracker.ietf.org/doc/html/rfc6819

Changelog
---------

Apr 04 2022
*   Changed cookie-session to express-session.
*   Added comments to make it more explicit that the use of a session to store
    the OAuth tokens was for demonstration purposes and a more secure method of
    persisting tokens should be used in production.
*   Added resource links for additional security best practices.

Jan 06 2022
*   Initial version.

Documentation
-------------

These examples are intended to accompany the guided walkthroughs on the
[Classroom Add-ons developer site][su-eapsite]. Please refer to the site for
implementation details.

[su-eapsite]: https://developers.google.com/classroom/eap/add-ons-alpha/

Requirements
------------
* [Node.js v16.13](https://nodejs.org/) or later

Project Setup
------------

1.  Create a [Google Cloud Platform (GCP)
    project](https://console.cloud.google.com/projectcreate).

    Enable the following in the API Library:
    *   [Google Workspace Marketplace (GWM) SDK][su-gwm]
    *   [Google Classroom API][su-classroom]

    Visit the developer site for [configuration instructions][su-config] for
    the GWM SDK. You will also need to [install the add-on][su-install]
    for it to be visible in Google Classroom.

[su-gwm]: https://console.cloud.google.com/apis/library/appsmarket-component.googleapis.com
[su-classroom]: https://console.cloud.google.com/apis/library/classroom.googleapis.com
[su-config]: https://developers.google.com/classroom/eap/add-ons-alpha/build-classroom-addon#step_3_google_workspace_marketplace_listing
[su-install]: https://developers.google.com/classroom/eap/add-ons-alpha/creating-simple-add-on#visit_the_unlisted_url_for_your_add-on_to_install_it

1.  Visit your project's [Credentials](https://console.cloud.google.com/apis/credentials)
    page. Create two credentials in the project:
    *   An **API Key**. You can leave it as **Unrestricted** for the purposes
        of these examples.
    *   An **OAuth client ID**.
        *   The application type should be **Web application**
        *   The **Name** can be anything you wish like `Web client 1`
        *   Add the following **Authorized JavaScript origins**
            *   `https://localhost:3000`
        *   Add the following **Authorized redirect URIs**
            *   `https://localhost:3000/google`
            *   `https://localhost:3000/google/callback`

    Return to the Credentials page once both have been created, then:
    *   Copy your **API Key** and assign it to the environment variable
        `GOOGLE_API_KEY`:
          ```shell
          export GOOGLE_API_KEY=YOUR_COPIED_API_KEY
          ```

1.  Clone this repository and `cd` into the project's root directory:

    ```shell
    git clone https://github.com/<org>/<repo>/
    cd <repo>
    ```

1.  Install required node modules using `npm`:

    ```shell
    npm install
    ```

1.  Download your client secrets as JSON from the Cloude console under
    **APIs & Services** > **Credentials** > **OAuth 2.0 Client IDs**.
    Look for a downlod button to the right of the row which contains
    your client. Save this file as `client_secret.json` in the repo
    root folder where you find `package.json`.

1.  Add to the `client_secret.json` file a secret word that will be used by the
    session manager.

    Make sure that `client_secret.json` is in your `.gitignore` file because
    you do not want to commit the file to git.

    ```json
    {
        "web": {
            ...existing config...
        },
        "session": {
            "secret": "REPLACE ME - this value needs to be a real secret."
        }
    }
    ```

1.  Create a self-certificate that will be used to run the application over
    HTTPS. These credentials should be saved as `sslcert/cert.pem` and
    `sslcert/key.pem` in the repo root folder. You may need to add these keys to
    your OS key chain in order for your browser to accept them.

    Make sure that `*.pem` is in your `.gitignore` file because you do not want
    to commit the file to git.

1.  You may run the application with the following command substituting `step01`
    for the correct step that you wish to run as a server. (e.g. `step01` for
    01-basic-app and `step02` for 02-sign-in, etc...)

    ```shell
    $ npm run step01

    or...
    $ npm run step02
    ```
    This will launch the webserver at `https://localhost:3000`.

1.  You may terminate the server with `Control + C` in your terminal.

1.  To load your app, either open the app in your browser or click the
    **Add-ons** button when creating an Assignment in
    [Google Classroom](https://classroom.google.com).

Understanding the files
------------

* Static files such as .js, .css and images are found in `./<step>/public`.
* Express routers are found in `./<step>/routes`.
* HTML Templates are found in `./<step>/views`.
* The server application is `./<step>/app.js`.

Walkthrough
------------
For a complete walkthrough of this project see the EAP documation.
1. [01-basic-app][walk-01]
2. [02-sign-in][walk-02]
3. [03-repeat-login][walk-03]

[walk-01]: https://developers.google.com/classroom/eap/add-ons-alpha/walkthroughs/create-an-add-on
[walk-02]: https://developers.google.com/classroom/eap/add-ons-alpha/walkthroughs/sign-in
[walk-03]: https://developers.google.com/classroom/eap/add-ons-alpha/walkthroughs/repeat-login

Useful Resources
-------------

<!-- *   [Issue tracker](https://github.com/<org>/<repo>/issues) -->
*   [Add-ons Guide][res-guide]
*   [Add-ons Reference][res-ref]
*   [Using OAuth 2.0 for Web Server Applications][res-oauth]
*   [OAuth 2.0 Scopes][res-scopes]
*   [Google Classroom API NodeJS Quickstart][res-quick]
*   [Google Cloud Node.js Client Libraries][res-libs]
*   [Classroom API Support][res-support]

[res-guide]: https://developers.google.com/classroom/eap/add-ons-alpha
[res-ref]: https://developers.google.com/classroom/eap/add-ons-alpha/reference/rest
[res-oauth]: https://developers.google.com/identity/protocols/oauth2/web-server#creatingclient
[res-scopes]: https://developers.google.com/identity/protocols/oauth2/scopes
[res-quick]: https://developers.google.com/classroom/quickstart/nodejs
[res-libs]: https://github.com/googleapis/google-cloud-node
[res-support]: https://developers.google.com/classroom/eap/add-ons-alpha/support


